﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IMMeDotNet {
	class Program {

		static void Main() {

			using (var testHost = new Host()) {

				var contacts = new List<Contact>();
				contacts.Add(new Contact("Echo"));
				contacts.Add(new Contact("Clock"));

				testHost.AttemptedLogIn += (sender, e) => {
					Console.WriteLine("{0} tried to log in (password: {1}).", e.Contact.Username, e.Password);
					e.Success = e.Password == e.Contact.Username;
				};
				testHost.LogIn += (sender, e) => {
					Console.WriteLine(e.Connection.Contact.Username + " logged in.");
				};
				testHost.LogOff += (sender, e) => {
					Console.WriteLine(e.Connection.Contact.Username + " logged out.");
				};
				testHost.RequestFriendList += (sender, e) => {
					Console.WriteLine(e.Connection.Contact.Username + " requested contact list.");
					e.Connection.Friends.Clear();
					e.Connection.Friends.AddRange(contacts);
				};
				testHost.RequestOnlineFriendList += (sender, e) => {
					Console.WriteLine(e.Connection.Contact.Username + " requested online contact list.");
					foreach (var item in e.Connection.Friends) {
						item.IsOnline = true;
					}
				};
				testHost.FriendRemoved += (sender, e) => {
					contacts.Remove(e.Friend);
					Console.WriteLine(e.Friend.Username + " has been removed from the friend list of " + e.Connection.Contact.Username);
				};
				testHost.FriendAdded += (sender, e) => {
					contacts.Add(e.Friend);
					Console.WriteLine(e.Friend.Username + " has been added to the friend list of " + e.Connection.Contact.Username);
				};
				testHost.MessageReceived += (sender, e) => {
					Console.WriteLine("[In] {0}->{1} : {2}", e.Message.Sender.Username, e.Message.Recipient.Username, e.Message.Text);
					switch (e.Message.Recipient.Username.ToString().ToLowerInvariant()) {
						case "echo":
							e.Connection.SendMessage(e.Message.Recipient, e.Message.Text);
							break;
						case "clock":
							switch (e.Message.Text.ToString().ToLowerInvariant()) {
								case "d":
									e.Connection.SendMessage(e.Message.Recipient, new IMMeString(DateTime.Now.ToLongDateString()));
									break;
								case "t":
									e.Connection.SendMessage(e.Message.Recipient, new IMMeString(DateTime.Now.ToLongTimeString()));
									break;
								default:
									e.Connection.SendMessage(e.Message.Recipient, new IMMeString("Type 'd' for the date, 't' for the time."));
									break;

							}
							break;
					}
					
				};
				testHost.MessageSent += (sender, e) => {
					Console.WriteLine("[Out] {0}->{1} : {2}", e.Message.Sender.Username, e.Message.Recipient.Username, e.Message.Text);
				};
				testHost.DiscussionEnded += (sender, e) => {
					Console.WriteLine("Discussion ended between {0} and {1}.", e.Connection.Contact.Username, e.Friend.Username);
				};
				#if POLLED_USB_INPUT
				while (!Console.KeyAvailable) {
					testHost.PollInput();
				}
				#else
				while (Console.ReadKey(true).Key != ConsoleKey.Escape) ;
				#endif
			}
		}
	}
}
